<!DOCTYPE html>
<html lang="">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<!-- Mobile Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
	<title>Cedar App for Keepsakes</title>
	<!-- fonts -->
	<link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,700,500italic,700italic,900|Roboto+Condensed:400,700|Roboto+Mono|Roboto+Slab' rel='stylesheet' type='text/css'>
	<!-- Bootstrap CSS -->
	<link href="css/bootstrap.css" rel="stylesheet">
	<link rel="shortcut icon" href="/img/cedar.png" type="image/x-icon" />
	<!-- custom css -->
	<link href="css/style.css" rel="stylesheet">
	<link href="css/jquery.fullpage.css" rel="stylesheet">
	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		
	</head>
	<body>
		<div id="main-wrapper">
			<header>
				<div class="menu">
					<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
						<div class="container">
							<div>
								<a class="navbar-brand scrollup" href="#top">
									<img class="logo-nav img img-responsive" alt="logo" src="img/cedar-logo.svg">
								</a>
							</div>
							<div class="other">
								<ul class="nav navbar-nav navbar-right">
									<li>
										<a href="https://play.google.com/store/apps/details?id=com.incendiary.cedar" target="_blank">
											<img src="img/googleplay-icon.png" class="img img-responsive" alt="">
										</a>
									</li>
									<li>
										<a href="#ios" class="page-scroll">
											<img src="img/iosapp-icon.png" class="img img-responsive" alt="">
										</a>
									</li>
								</ul>
							</div>
							<div class="small-mobile">
								<ul class="nav navbar-nav navbar-right">
									<li>
										<a href="https://play.google.com/store/apps/details?id=com.incendiary.cedar" target="_blank">
											<img src="img/google.png" class="img img-responsive" alt="">
										</a>
									</li>
									<li>
										<a href="#ios" class="page-scroll">
											<img src="img/apple.png" class="img img-responsive" alt="">
										</a>
									</li>
								</ul>
							</div>
						</div>
					</nav>
				</div>
			</header>
			<div id="main-content">
				<div id="fullpage">
					<div class="section active ">
						<section id="section0" class=" home-section">
							<div class="container">
								<div class="row text-center">
									<div class="cedar-mobile col-md-5 col-sm-12">
										<img src="img/cedar-mobile-app.png" class="img" alt="Image">
									</div>
									<div class="col-md-7 col-sm-12">
										<div class="box">
											<div class="logo text-center">
												<img src="img/cedar-logo.svg"  class=" img " alt="">
											</div>
											<div class="content">
												<h2>The App for Keepsakes</h2>
												<p>Cedar is a photo journal app to help you capture, organize and engage with your mementos.<br/><br/>Save the story behind every keepsake. Build your personal archive of nostalgia.</p>
											</div>
											<div class="download ">
												<ul>
													<li><a href="https://play.google.com/store/apps/details?id=com.incendiary.cedar" target="_blank"><img src="img/googleplay-icon.png" class="img img-responsive " alt=""></a></li>
													<li><a href="#ios" class="page-scroll"><img src="img/iosapp-icon.png" class="img img-responsive " alt=""></a></li>
												</ul>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class=" text-center col-xs-12 col-sm-12 col-md-12 col-lg-12">
										<div class="scroll-down">
											<span><a href="#section1" class="page-scroll"><img src="img/down.png" alt="scroll down"></a></span>
											<a href="#section1" class="page-scroll"><p>Scroll Down</p></a>
										</div>
									</div>
								</div>
							</div>
						</section>
					</div>
					<div class="section ">
						<section id="section1" class="feature-section">
							<div class="container">
								<div class="">
									<div class="row">
										<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
											<div class="headline text-center">
												<h3>Features</h3>

												<span>
													<img src="img/cedarbox-icon.png" class="box-icon img " alt="">
												</span>

											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
											<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
												<div class="feature-detail">
													<div class="round-icon">
														<span class="lnr lnr-camera">
														</span>
														<h4>Capture</h4>
													</div>
													<p>
														Add details like the story and date for each keepsake photo.
													</p>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
												<div class="feature-detail">
													<div class="round-icon">
														<span class="lnr lnr-layers">
														</span>
														<h4>Organize</h4>
													</div>
													<p>
														Store photos by
														theme and timeframe
														to organize your
														collection.
													</p>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
												<div class="feature-detail">
													<div class="round-icon">
														<span class="lnr lnr-rocket">
														</span>
														<h4>Engage</h4>
													</div>
													<p>
														Easily share images on social media and get reminders sent to you automagically.
													</p>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
												<div class="feature-detail">
													<div class="round-icon">
														<span class="lnr lnr-picture">
														</span>
														<h4>Create</h4>
													</div>
													<p>
														Incorporate keepsakes into personalized e-cards or everyday items like tote bags & coffee mugs.
													</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</section>
					</div>
					<div class="section ">
						<section id="section2" class=" gallery-section">
							<div class="container">
								<div class="row">
									<div class="">
										<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
											<div class="headline2 text-center">
												<h3>Keepsakes Gallery</h3>

												<span>
													<img src="img/cedarboxwhite-icon.png" class="box-icon img " alt="">
												</span>

											</div>
										</div>
										<div class="text-center col-xs-12 col-sm-12 col-md-12 col-lg-12">
											<div class="gallery col-md-10 col-md-offset-1">
												<ul>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Baseball</h4></div>
															<span class="date">2010</span>
															<p>
																Ticket stubs from two Atlanta Braves games at Turner Field. Summer visits to GA.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image1.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Travel trinkets</h4></div>
															<span class="date">2005</span>
															<p>
																Carved wood statue picked up in Dominican Republic on trip to visit Maria.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image2.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Sam’s Art</h4></div>
															<span class="date">2015</span>
															<p>
																Bumblebee and flowers done by Sam at school
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image3.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Weddings</h4></div>
															<span class="date">June 17 2014</span>
															<p>
																Sarah &amp; Ben’s Save the Date card.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image4.png" alt="">
														</div>
													</li>

													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
															<span class="date">2002</span>
															<p>
																Charcoal and pastel crayons class with Dory
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image5.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Peachtree Shirts!</h4></div>
															<span class="date">July 2011</span>
															<p>
																Race time 52:34. Five runners in our group this year (Sally, Ted, Kathy, John, me)
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image6.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Family Stuff</h4></div>
															<span class="date">1920</span>
															<p>
																Great-grandmother’s sewing machine. Looks like an old Singer crank model.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image7.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Travel trinkets</h4></div>
															<span class="date">June 2005</span>
															<p>
																Alpaca carpet from Chile – bought in a market near San Pedro de Atacama
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image8.png" alt="">
														</div>
													</li>

													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Holiday Cards</h4></div>
															<span class="date">Dec 2014</span>
															<p>
																Card from Jordan &amp; Victoria.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image9.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Family Stuff</h4></div>
															<span class="date">1950</span>
															<p>
																Grandpa’s childhood ski hill, right across the street from his farm and run by his uncle. Family shop at the bottom where both Grandpa and Grandma worked served homemade ice cream.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image10.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Life Wins</h4></div>
															<span class="date">Oct 4 2009</span>
															<p>
																Man Against Horse Race. Prescott, AZ – 50 miles over the Mingus Mountain against the horseback riders. Took 12 hours but I finished! Proud of this one.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image11.png" alt="">
														</div>
													</li>
													<li>
														<div class="meta-box">
															<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> NYC Trip</h4></div>
															<span class="date">August 22 2015</span>
															<p>
																Saw Wicked on Broadway with Pam. New York pizza after the show.
															</p>

														</div>
														<div class="box-image">
															<img src="img/gallery-image12.png" alt="">
														</div>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
						</section>
					</div>
					<div class="section ">
						<section id="section3" class="coming-section">
							<div class="container">
								<div class="row subscribe">
									<div class="col-xs-12 col-sm-3 col-md-4 text-center">
										<img src="img/apple-icon.png" class="img apple-icon" alt="">
									</div>
									<div class="col-xs-12 col-sm-9 col-md-8">
										<div class="callaction">
											<h1>Cedar for iOS is coming soon</h1>
											<span>Join our waiting list and you will be the first to know when Cedar launches for iPhone and iPad.</span>

											<div class="form-group">
												<!-- <label class="sr-only" for="">label</label> -->
												<input type="email" id="ios_email" class="form-control" id="" placeholder="Email Address">
											</div>
											<div class="msg">
												<div id="ios_email_div" class="confirm" ></div>
												<div id="error-email" style="color:red" ></div>
											</div>
											<button type="submit" class="btn btn-color" onclick="myFunction()">Let me know</button>
										</div>
									</div>
								</div>
							</div>
						</section>
						<div id="main-footer">
								<div class="scroll">
									<a href="#home" class="scrollup"><img src="img/scroll-up.png" alt=""></a>
								</div>
								<footer>
									<div class="container text-center">
										<div class="social">
											<ul>
												<li>
													<div class="fb-like" data-href="https://www.facebook.com/getcedar/" data-layout="button_count" data-action="like" data-show-faces="true" data-share="false"></div>
												</li>
												<li>
													<img src="img/cedar-icon.png" class="img" alt="">
												</li>
												<li>
													<div class="cedar-twitter-likes">
														<a href="https://twitter.com/share" class="twitter-share-button" data-url="https://twitter.com/getcedar/">Tweet</a>
														<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
													</div>
												</li>
											</ul>
										</div>
										<div classs="row">
											<div class="col-xs-6 text-right footer-links"><a href="/user/about_us">About Us</a></div>
											<div class="col-xs-6 text-left footer-links"><a href="/user/contact_us">Contact Us</a></div>
										</div>
										<div classs="row">
											<div class="col-xs-6 text-right footer-links">&copy; Cedar 2015</div>
											<div class="col-xs-6 text-left footer-links">Made in Portland, OR</div>
										</div>
									</div>
								</footer>
							</div>
					</div>
				</div>
			</div>
		</div>
		<!-- jQuery -->
		<script src="js/jquery-2.1.4.min.js"></script>
		
		<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script> -->
		<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.1/jquery-ui.min.js"></script> -->
		<!-- Bootstrap JavaScript -->
		<script src="js/bootstrap.min.js"></script>
		<script src="js/jquery.fullpage.js"></script>
		<script src="js/jquery.easings.min.js"></script>
		<!-- <script src="js/jquery.slimscroll.js"></script> -->
		<script src="js/retina.min.js"></script>
		<script src="js/scripts.js"></script>
		<script type="text/javascript">
			
			function myFunction()
			{
				$email = $('#ios_email').val();
				
				var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
				
				if($email == '')
				{
					document.getElementById('ios_email_div').innerHTML ="" ;
					document.getElementById('error-email').innerHTML = "Email field cannot be empty";
				}
				else if (filter.test($email))
				{
					$.ajax({
						url: '/site/add-waiting-iosusers',
						type: 'post',
						data:{
							'email':$email,
						},
						success: function (response) {
						//	alert(response);
						if(response == true)
						{
									//	$('#ios_email').val() = '';
									document.getElementById('ios_email').value = "";
									document.getElementById('error-email').innerHTML ="" ;
						//alert($('#ios_email').val());
						document.getElementById('ios_email_div').innerHTML = "Thank you for your interest in Cedar! You will be among the first to know when our iOS app is ready.";
					}
					else
					{
							//alert("please enter a skill");
							document.getElementById('ios_email_div').innerHTML ="" ;
							document.getElementById('error-email').innerHTML = "Your email id is already registered in the waiting list";
						}
					}
					
				});
					
					
					
				}
				else
				{
					//alert("please enter a skill");
					document.getElementById('ios_email_div').innerHTML ="" ;
					document.getElementById('error-email').innerHTML = "Please enter a Valid Email ID";
				}
			}
			$(document).ready(function() {
				document.getElementById('ios_email').value = "";
				$('#fullpage').fullpage({
					// verticalCentered: false,
					// lockAnchors: false,
					anchors:['top', 'features', 'gallery', 'ios'],
					//scrollBar: false,
					lockAnchors: false,
					//touchSensitivity: 15,
					responsiveWidth: 1100,
					autoScrolling: false,
					keyboardScrolling: true,
					fitToSection: false
										//scrollOverflow:true
									});
				
				$(document).on('click', '.scrollup', function(){
					$.fn.fullpage.moveTo('top', 1);
				});
			});
		</script>
		<div id="fb-root"></div>
		<script>(function(d, s, id) {var js, fjs = d.getElementsByTagName(s)[0];
			if (d.getElementById(id)) return;
			js = d.createElement(s); js.id = id;
			js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
			fjs.parentNode.insertBefore(js, fjs);}
			(document, 'script', 'facebook-jssdk'));
	</script>
	<script>
		(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
			(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
			m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		})(window,document,'script','//www.google-analytics.com/analytics.js','ga');
		ga('create', 'UA-69818316-1', 'auto');
		ga('send', 'pageview');
	</script>
</body>
</html>
