<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "photo".
 *
 * @property integer $id
 * @property string $s3_image_url
 * @property string $note
 * @property string $keepsake_date
 * @property integer $user_id
 * @property string $created_on
 * @property string $modified_on
 * @property integer $status
 */
class Photo extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'photo';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['note', 'image'], 'string'],
            [['user_id', 'status','box_id'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['keepsake_date'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
	    'image' => 'Image',
            'note' => 'Note',
            'keepsake_date' => 'Keepsake Date',
            'box_id' =>'Box Id',
            'user_id' => 'User ID',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'status' => 'Status',
        ];
    }
}
