<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "allowed_ips".
 *
 * @property integer $id
 * @property integer $admin_id
 * @property string $allowed
 * @property string $ip_address
 */
class AllowedIps extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'allowed_ips';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['admin_id', 'ip_address'], 'required'],
            [['id', 'admin_id'], 'integer'],
            [['allowed'], 'string'],
            [['ip_address'], 'string', 'max' => 250]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'admin_id' => 'Admin ID',
            'allowed' => 'Allowed',
            'ip_address' => 'Ip Address',
        ];
    }
}
