<?php
namespace common\models;

use Yii;
use yii\base\Model;
use common\models\AllowedIps;

/**
 * Login form
 */
class AdminLoginForm extends Model
{
    public $username;
    public $password;
    public $rememberMe = true;
	public $ip;
    private $_user = false;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            // username and password are both required
            [['username', 'password'], 'required'],
            // rememberMe must be a boolean value
            ['rememberMe', 'boolean'],
            // password is validated by validatePassword()
            ['password', 'validatePassword'],
        ];
    }

    /**
     * Validates the password.
     * This method serves as the inline validation for password.
     *
     * @param string $attribute the attribute currently being validated
     * @param array $params the additional name-value pairs given in the rule
     */
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();
            if (!$user || !$user->validatePassword($this->password)) {
                $this->addError($attribute, 'Incorrect username or password.');
            }
			else
			{
				if(!$this->validate_ips($user,$this->ip))
				{
					$this->addError($attribute, 'Your IP address is not approved. Please contact Superadmin');
				}
			}
			if(!$this->check_status($this->username))
			{
				$this->addError($attribute, 'Account is deactivated. Please contact superadmin');
			}
        }
    }

    /**
     * Logs in a user using the provided username and password.
     *
     * @return boolean whether the user is logged in successfully
     */
    public function login()
    {
        if ($this->validate()) {
            return Yii::$app->user->login($this->getUser(), $this->rememberMe ? 3600 * 24 * 30 : 0);
        } else {
            return false;
        }
    }

    /**
     * Finds user by [[username]]
     *
     * @return User|null
     */
    public function getUser()
    {
        if ($this->_user === false) {
            $this->_user = Admin::findByUsername($this->username);
        }

        return $this->_user;
    }
	
	public function check_status($username)
	{
		$res = Admin::findOne(['username'=>$username]);
		if($res != '' && $res->status == 'inactive')
		{
			return false;
		}
		return true;
	}
	
	/**
	 * To provide the IP protection to admin panel
	 */
	public function validate_ips($user,$ip)
	{
		if($existing_ip = AllowedIps::findOne(['ip_address'=>$ip,'admin_id'=>$user->id]))
		{
			if($existing_ip->allowed == 'no')
			{
				if($user->is_superadmin == 'yes')
				{
					return TRUE;
				}
				return FALSE;
			}
		}
		else 
		{
			$ips = new AllowedIps();
			$ips->admin_id = $user->id;
			$ips->allowed = 'no';
			$ips->ip_address = $ip;
			$ips->save();
			//print_r($ips);
			return FALSE;
		}
		
		return true;
		
		
	}
}
