jQuery(document).ready(function($){
	
	if( $('.fancy-form').length > 0 ){
		floatLabels();
	}

	function floatLabels() {
		var formGroup = $('.fancy-form .cedar-form-group');
		
		$(formGroup).each(function(){
			
			var inputFields = $(this).find('input');
			var labels = $(this).find('label.fancy-label');
			
			//run this for first time to relocate lables if value is present
			checkVal(inputFields);
			
			//focus on the input field on click of label
			$(labels).click(function(){
				
				//focus on input
				inputFields.focus();
			});
			
			//handle labels when user is filling the form
			inputFields.on('change keyup input', function(){
				checkVal($(this));
			});
			
		});
		
		/*$(inputFields).each(function(){
			
			var singleInput = $(this);
			//console.log($(this));
			
			//check if user is filling one of the form fields 
			checkVal(singleInput);
			
			singleInput.on('change keyup', function(){
				//console.log('input', $(this));
				checkVal(singleInput);
			});
		});*/
	}

	function checkVal(inputField) {
		var formGroup = $(inputField).closest('.cedar-form-group');		
		( inputField.val() == '' ) ? formGroup.removeClass('fancy-form-group') : formGroup.addClass('fancy-form-group');
	}
});