<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;


/* @var $this yii\web\View */
/* @var $model common\models\Admin */

$this->title = 'Add New Admin';
$this->params['breadcrumbs'][] = ['label' => 'Admins', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-create">

    <h1><?= Html::encode($this->title) ?></h1>

	<?php $form = ActiveForm::begin(); ?>

	    <?= $form->field($model, 'username')->textInput(['maxlength' => true])->label('Unique Username') ?>
	
	    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
	    
	    <?= $form->field($model, 'password')->passwordInput(['maxlength' => true]) ?>
	    
	    <?= $form->field($model, 'confirmPassword')->passwordInput(['maxlength' => true]) ?>
		
	    <?= $form->field($model, 'status')->radioList(array('active'=>'active','inactive'=>'inactive')) ?>
	    
	    <?= $form->field($model, 'is_superadmin')->radioList(array('yes'=>'yes','no'=>'no')) ?>
	
	    <div class="form-group">
	        <?= Html::submitButton('Create', ['class' => 'btn btn-success']) ?>
	    </div>

    <?php ActiveForm::end(); ?>
</div>
