<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Photo */
if(isset($user_id))
{
	$user = $user_id;
	$this->params['breadcrumbs'][] = ['label' => 'Users', 'url' => ['index']];
	$this->params['breadcrumbs'][] = ['label' => $user, 'url' => ['/user/view','id'=>$user]];
}
else {
	$this->params['breadcrumbs'][] = ['label' => 'Photos', 'url' => ['index']];
}
$this->title = $model['id'];

$this->params['breadcrumbs'][] = $this->title;
?>
<div class="photo-view">
<?php
//print_r($model);
//die();
?>
    <h1><?= Html::encode($this->title) ?></h1>

    <p>
    	<?php
    	if(!isset($user_id))
		{
			?>	
        <?= Html::a('Update', ['update', 'id' => $model['id']], ['class' => 'btn']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model['id']], [
            'class' => 'btn',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
        <?php
		}
		?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => '-'],
        'attributes' => [
            'id',
            //'image:ntext',
            [
		    'attribute'=>'image',
		    'value'=>$model['image'],
		    'format' => ['image',['width'=>'100','height'=>'100']],
			],
            'note:ntext',
            'keepsake_date',
            [
            'attribute'=>'first_name',
            'label'=>'User Name',
            'format'=>'raw',
            'value'=> Html::a($model['first_name'].' '.$model['last_name'],Url::to(['user/view', 'id'=>$model['user_id']]))
            ],
           // 'user_id',
            [
            'attribute'=>'name',
            'label'=>'Box Name',
            'value'=> $model['name']
            ],
            'created_on',
            'modified_on',
            'status',
        ],
    ]) ?>

</div>
