<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\IosWaitingList;

/**
 * iosSearch represents the model behind the search form about `common\models\IosWaitingList`.
 */
class iosSearch extends IosWaitingList
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['email_id', 'created_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = IosWaitingList::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
		
		//$dataProvider->sort = ['defaultOrder' => ['id' => 'ASC']]; 
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_on' => $this->created_on,
        ]);

        $query->andFilterWhere(['like', 'email_id', $this->email_id]);

        return $dataProvider;
    }
}
