<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use common\models\Photo;

/**
 * UserSearch represents the model behind the search form about `common\models\User`.
 */
class UserSearch extends User
{
	public $photo;
	public $count;
	public $first_captured;
	public $last_captured;
	//public $country;
 
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['first_name', 'last_name', 'email', 'password', 'password_reset_token', 'profile_picture', 'status', 'created_on', 'modified_on','photo','count','first_captured','last_captured'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
    	//print_r($params);
        $query = User::find();
		$query->select('user.*,'.$this->first_captured.','.$this->last_captured.', 
		count(photo.id) as count,
		max(photo.created_on) as last_captured,
		min(photo.created_on) as first_captured
		')
		->groupBy('user.id')
		->leftJoin('photo', '`user`.`id` = `photo`.`user_id`');
		
		//print_r($query->createCommand()->getRawSql());
		//print_r($this->last_captured);
		//die();
		/*
        ->select('user.*,min(photo.created_on) as first_captured1,max(photo.created_on),count(`photo`.`id`)')
		->leftJoin('photo', '`user`.`id` = `photo`.`user_id`');
		*/
		
		
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['attributes' => ['id','first_name','last_name','email','created_on','modified_on','status','first_captured.created_on','last_captured','count']]
        ]);
		$dataProvider->setSort([
        'attributes' => [
        	'id',
        	'first_name',
        	'last_name',
        	'email',
        	'created_on'=> [
                'asc' => ['user.created_on' => SORT_ASC],
                'desc' => ['user.created_on' => SORT_DESC],
                'label' => 'user.created_on',
                'default' => SORT_ASC
            ],
        	'modified_on',
        	'status'=>[
                'asc' => ['user.status' => SORT_ASC],
                'desc' => ['user.status' => SORT_DESC],
                'label' => 'user.status',
                'default' => SORT_ASC
            ],
            //'id',
            'first_captured' => [
                'asc' => ['first_captured' => SORT_ASC],
                'desc' => ['first_captured' => SORT_DESC],
                'label' => 'photo.created_on',
                'default' => SORT_ASC
            ],
            'last_captured' => [
                'asc' => ['last_captured' => SORT_ASC],
                'desc' => ['last_captured' => SORT_DESC],
                'label' => 'photo.created_on',
                'default' => SORT_ASC
            ],
            'count' => [
                'asc' => ['count' => SORT_ASC],
                'desc' => ['count' => SORT_DESC],
                'label' => 'count',
                'default' => SORT_ASC
            ],
        ]
    	]);
		
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
             $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'user.id' => $this->id,
            //'user.created_on' => $this->created_on,
            //'user.modified_on' => $this->modified_on,
            //'photo.created_on' => $this->first_captured,
            //'photo.created_on' => $this->last_captured,
            'user.status'=>$this->status,
            //'count' => $this->count,
        ]);
		
        $query->andFilterWhere(['like', 'first_name', $this->first_name])
            ->andFilterWhere(['like', 'last_name', $this->last_name])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'password', $this->password])
            ->andFilterWhere(['like', 'password_reset_token', $this->password_reset_token])
            ->andFilterWhere(['like', 'profile_picture', $this->profile_picture])
			->andFilterWhere(['like', 'user.created_on', $this->created_on])
			->andFilterWhere(['like', 'user.modified_on', $this->modified_on])
			->andFilterWhere(['like', 'photo.created_on', $this->first_captured])
			->andFilterWhere(['like', 'photo.created_on', $this->last_captured])
            ;
			
		if($this->last_captured != '')
		{
			$query->andFilterWhere([
			'like', 'photo.created_on', $this->last_captured
			]);
		}
		//print_r($query);
		//die();	
		if(isset($params['UserSearch']))
		{
			if(isset($params['UserSearch']['count']) && $params['UserSearch']['count'] != '')
			{
				//print_r($query);
				$query->having('count(photo.id) ='. $params['UserSearch']['count']);
			}
		}
		//print_r($dataProvider);
        return $dataProvider;
		
    }

}
