<?php

namespace backend\models;

use common\models\Admin;
use common\models\AllowedIps;
use yii\base\Model;
use yii\db\Query;
use yii\helpers\Url;
use yii;

/**
 * This is the model class for table "admin".
 *
 * @property integer $id
 * @property string $username
 * @property string $email
 * @property integer $status

 */
class AdminForm extends Model
{
	public $username, $password,$confirmPassword,$email,$status,$id,$is_superadmin;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['username','email','password','confirmPassword','status'], 'required'],
            [['username','status','is_superadmin'], 'string', 'max' => 255],
            [['email'], 'email'],
            [['password'],'string','min'=>6],
            [['confirmPassword'],'compare','compareAttribute'=>'password', 'message'=>"Passwords don't match"],
            ['username', function ($attribute, $params) {
				if(Admin::findOne(['username'=>$this->$attribute]))
				{
					$this->addError($attribute, 'Username is already exist');
					
				}
            }],
            ['email', function ($attribute, $params) {
				if(Admin::findOne(['email'=>$this->$attribute]))
				{
					$this->addError($attribute, 'Email is already exist');
					
				}
            }],
            
        ];
    }
	
	public function saveForm()
	{
		$admin = new Admin();
		$admin->username = $this->username;
		$admin->email = $this->email;
		$admin->status = $this->status;
		$admin->setPassword($this->password);
		$admin->generateAuthKey();
		$admin->is_superadmin = $this->is_superadmin;
		if($admin->validate())
		{
			$admin->save();
			return $admin;
		}
		else 
		{
			return $admin;	
		}
	}
	
	public function update_allowed($id,$checked)
	{
		$ip_allowed = AllowedIps::findOne(['id'=>$id]);
		$ip_allowed->allowed = ($checked == "true")?'yes':'no';
		$ip_allowed->save();
		return true;
	}
}