<?php

namespace backend\controllers;

use Yii;
use common\models\Admin;
use common\models\AllowedIps;
use backend\models\AdminSearch;
use backend\models\ipSearch;
use backend\models\AdminForm;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * SuperAdminController implements the CRUD actions for Admin model.
 */
class SuperAdminController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Admin models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AdminSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Admin model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Admin model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new AdminForm();
		if ($model->load(Yii::$app->request->post()) && ($model->validate())) {
			$admin = $model->saveForm();
        	return $this->redirect(['view', 'id' => $admin->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Admin model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
        	if($model->is_superadmin == 'no' && Yii::$app->user->identity->username == $model->username)
			{
				return $this->redirect('/backend/web/index.php?r=user/index',302);
			}
        	
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Admin model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Admin model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Admin the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Admin::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

	/**
     * Lists all AllowedIps models.
     * @return mixed
     */
    public function actionIpIndex()
    {
    	//print_r($_SERVER);
		
        $searchModel = new ipSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('/ip-allowed/index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single AllowedIps model.
     * @param integer $id
     * @return mixed
     */
    public function actionIpView($id)
    {
        return $this->render('/ip-allowed/view', [
            'model' => $this->findIpModel($id),
        ]);
    }

    /**
     * Creates a new AllowedIps model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionIpCreate()
    {
        $model = new AllowedIps();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['/ip-allowed/view', 'id' => $model->id]);
        } else {
            return $this->render('/ip-allowed/create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing AllowedIps model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionIpUpdate($id)
    {
        $model = $this->findIpModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['/ip-allowed/view', 'id' => $model->id]);
        } else {
            return $this->render('/ip-allowed/update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing AllowedIps model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionIpDelete($id)
    {
        $this->findIpModel($id)->delete();

        return $this->redirect(['ip-index']);
    }

    /**
     * Finds the AllowedIps model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return AllowedIps the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findIpModel($id)
    {
        if (($model = AllowedIps::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function actionUpdateAllowed()
	{
		$post_data = Yii::$app->request->post();
		
		$ip_details = $this->findIpModel($post_data['id']);
		if($post_data != '')
		{
			if($post_data['checked'] == "true")
			{
				Yii::$app->session->setFlash('success', $ip_details->ip_address." is allowed to access the Admin Panel ");
			
			}
			else {
				Yii::$app->session->setFlash('error', $ip_details->ip_address." is restricted to access the Admin Panel ");
			
			}
			//print_r($post_data);
			$model = new AdminForm();
			$model->update_allowed($post_data['id'],$post_data['checked']);
			return $this->redirect('/backend/web/index.php?r=super-admin/ip-index',302);
			//return true;
		}
	}
}
