<?php
namespace api\modules\v1\controllers;

use Yii;

use yii\rest\ActiveController;
use common\models\LoginForm;
use common\models\User;
use frontend\models\Photo;
use yii\filters\auth\CompositeAuth;
use yii\filters\auth\HttpBasicAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\filters\auth\QueryParamAuth;
use yii\data\ActiveDataProvider;

class PhotoController extends ActiveController
{
    // We are using the regular web app modules:
    public $modelClass = 'frontend\models\Photo';
    //Method to search for an item in db with matching get value request. This is used for email and password check
    public function actionSearch()
    {   
	$userid = false;
	$post_data = Yii::$app->request->post();
        if (!empty($post_data)) {
            $model = new $this->modelClass;
                foreach (Yii::$app->request->post() as $key => $value) {
		    //This for getting the photos with user_id less than the given number. This is to get the element page by pae. (#485)		   		    
		    if($key == 'id')
		    {
			
			$userid = $value;
		    	unset($post_data['id']);
		    }
                    if (!$model->hasAttribute($key)) {
                        throw new \yii\web\HttpException(404, 'Invalid attribute:' . $key);
                    }
                }
            try {
		if($userid == false)
		{
			$query = $model->find()->where($post_data);
		}else
		{
			$query = $model->find()->where($post_data)->andWhere('id < :userid', [':userid' => $userid]);
		}
                $provider = new ActiveDataProvider([
                    'query' => $query,
                    'pagination' => [
                    'defaultPageSize' =>10,
		    'pageSize' => 10, //default number of records in GET request 
            		],
	    	    'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]]
                ]);
            } catch (Exception $ex) {
                throw new \yii\web\HttpException(500, 'Internal server error');
            }

            if ($provider->getCount() <= 0) {
                throw new \yii\web\HttpException(404, 'No entries found with this query string');
            } else {
                return $provider;
            }
	    } else {
		throw new \yii\web\HttpException(400, 'There are no query string');
	    }
	   
    }
     public function actionAll(){
		$post_data = Yii::$app->request->post();
		if (!empty($post_data)) {
		    $model = new $this->modelClass;
		        foreach (Yii::$app->request->post() as $key => $value) {
		            if (!$model->hasAttribute($key)) {
		                throw new \yii\web\HttpException(404, 'Invalid attribute:' . $key);
		            }
		        }
            try {
                $provider = new ActiveDataProvider([
                    'query' => $model->find()->where(Yii::$app->request->post()),
                    'pagination' => false,
		    'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]]
                ]);
            } catch (Exception $ex) {
                throw new \yii\web\HttpException(500, 'Internal server error');
            }

            if ($provider->getCount() <= 0) {
                throw new \yii\web\HttpException(404, 'No entries found with this query string');
            } else {
                return $provider;
            }
	    } else {
		throw new \yii\web\HttpException(400, 'There are no query string');
	    }
     }
     public function actions(){ 
        $actions = parent::actions();
        unset($actions['index']);
        return $actions;
    }
    public function actionIndex(){
        $activeData = new ActiveDataProvider([
            'query' => Photo::find(),
            'pagination' => [
                'defaultPageSize' =>10,
		'pageSize' => 5, //default number of records in GET request 
            ],
	    'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]]
        ]);
        return $activeData;
    }
}
