<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>
<?php $form = ActiveForm::begin() ?>
<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<!-- Mobile Meta -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
		<title>Cedar App for Keepsakes</title>
		<!-- fonts -->
		<link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,700,500italic,700italic,900|Roboto+Condensed:400,700|Roboto+Mono|Roboto+Slab' rel='stylesheet' type='text/css'>
		<!-- Bootstrap CSS -->
		<link href="/css/bootstrap.css" rel="stylesheet">
		<link rel="shortcut icon" href="/img/cedar.png" type="image/x-icon" />
		<!-- custom css -->
		<link href="/css/style.css" rel="stylesheet">
		<!-- <link href="/css/jquery.fullpage.css" rel="stylesheet"> -->
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		
	</head>
<body>
	<div id="main-wrapper">
		<div id="fullpage">
			<div id="main-content">
				<section class="reset-section">
					<div class="container">
						<div class="row">
							<div class=" col-md-12 col-sm-12">
								<div class="resetbox">
									<div class="logo text-center">
										<img src="/img/cedar-logo.svg"  class=" img " alt="Cedar for keepsakes">
									</div>
									<?php if(isset($success) && $success == true)
									{
										?>
										<div id="after_reset" class="content success-head" >
											<h4>The App for Keepsakes</h4>
											<!-- <h2>Reset your Password</h2> -->
											<img src="/img/imgo.jpeg" alt="success">
											<h2>Password Reset</h2>
											<span>Your Password has been reset successfully.</span>
										</div>
										<?php
									}else if(isset($error) && $error == true)
									{
										?>
										<div id="after_reset" class="content error-head" >
											<h4>The App for Keepsakes</h4>
											<!-- <h2>Reset your Password</h2> -->
											<img src="/img/imgo1.jpeg" alt="error">
											<h2>Invalid Password Token</h2>
										</div>
										<?php
									}
									else
									{
										?>
										<div id="before_reset" class="content head">
											<h4>The App for Keepsakes</h4>
											<h2>Reset your Password</h2>
											<form action="" method="POST" role="form" class="resetform">
												<div class="form-group">
													<!--<input type="text" class="form-control reset" id="" placeholder="Enter Password">-->
													<?= $form->field($model, 'password')->passwordInput(['class'=>'form-control reset','placeholder'=>'Enter Password'])->label(false)?>
												</div>
												<div class="form-group">
													<!--<input type="text" class="form-control reset" id="" placeholder="Re-enter Password">-->
													<?= $form->field($model, 're_enter_password')->passwordInput(['class'=>'form-control reset','placeholder'=>'Re-enter Password'])->label(false)?>
												</div>
												<button type="submit" class="btn btn-bigcolor">Submit</button>
												<!--<?= Html::submitButton('Submit', ['class' => 'btn btn-bigcolor']) ?>-->
											</form>
										</div>
										<?php
									}
									?>
									<div class="appdownload text-center">
										<ul>
											<li><a href="https://play.google.com/apps/testing/com.incendiary.cedar" target="_blank"><img src="/img/googleplay-icon.png" class="img img-responsive " alt="Download cedar at google play store"></a></li>
											<li><a href="http://getcedar.io/#ios" class="page-scroll"><img src="/img/iosapp-icon.png" class="img img-responsive " alt="Download cedar at apple app store"></a></li>
										</ul>
									</div>
								</div>
							</div>

						</div>
					</div>
				</section>
			</div>
			<div id="main-footer">
				<footer>
					<div class="container text-center">
						<div class="social">
							<ul>
								<li>
									<div class="fb-like" data-href="https://www.facebook.com/getcedar/" data-layout="button_count" data-action="like" data-show-faces="true" data-share="false"></div>
								</li>
								<li>
									<img src="/img/cedar-icon.png" class="img" alt="Cedar for keepsakes">
								</li>
								<li>
									<div class="cedar-twitter-likes">
										<a href="https://twitter.com/share" class="twitter-share-button" data-url="https://twitter.com/getcedar/">Tweet</a>
										<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
									</div>
								</li>
							</ul>
						</div>
						<div classs="row">
							<div class="col-xs-6 text-right footer-links"><a href="/user/about_us">About Us</a></div>
							<div class="col-xs-6 text-left footer-links"><a href="/user/contact_us">Contact Us</a></div>
						</div>
						<div classs="row">
							<div class="col-xs-6 text-right footer-links">&copy; Cedar 2015</div>
							<div class="col-xs-6 text-left footer-links">Made in Portland, OR</div>
						</div>
					</div>
				</footer>
			</div>
		</div>
	</div>
	<!-- jQuery -->
	<script src="/js/jquery-2.1.4.min.js"></script>
	<!-- Bootstrap JavaScript -->
	<script src="/js/bootstrap.min.js"></script>
	<!-- // <script src="js/main.js"></script> -->
	<div id="fb-root"></div>
	<script>(function(d, s, id) {
		var js, fjs = d.getElementsByTagName(s)[0];
		if (d.getElementById(id)) return;
		js = d.createElement(s); js.id = id;
		js.src = "//connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v2.5";
		fjs.parentNode.insertBefore(js, fjs);
	}(document, 'script', 'facebook-jssdk'));</script>
</body>
