<!DOCTYPE html>
<html lang="">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<!-- Mobile Meta -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
		<title>Cedar App for Keepsakes</title>
		<!-- fonts -->
		<link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,700,500italic,700italic,900|Roboto+Condensed:400,700|Roboto+Mono|Roboto+Slab' rel='stylesheet' type='text/css'>
		<!-- Bootstrap CSS -->
		<link href="/css/bootstrap.css" rel="stylesheet">
		<link rel="shortcut icon" href="/img/cedar.png" type="image/x-icon" />
		<!-- custom css -->
		<link href="/css/style.css" rel="stylesheet">
		<!-- <link href="/css/jquery.fullpage.css" rel="stylesheet"> -->
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		
	</head>
	<body>
		<div id="main-wrapper">
			<header>
				<div class="menu">
					<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
						<div class="container">
							<div>
								<a class="navbar-brand scrollup" href="http://getcedar.io/">
									<img class="logo-nav img img-responsive" alt="logo" src="/img/cedar-logo.svg">
								</a>
							</div>
							<div class="other">
								<ul class="nav navbar-nav navbar-right">
									<li>
										<a href="https://play.google.com/apps/testing/com.incendiary.cedar" target="_blank">
											<img src="/img/googleplay-icon.png" class="img img-responsive" alt="Download cedar at google play store">
										</a>
									</li>
									<li>
										<a href="http://getcedar.io/#ios" class="page-scroll">
											<img src="/img/iosapp-icon.png" class="img img-responsive" alt="Download cedar at apple app store">
										</a>
									</li>
								</ul>
							</div>
							<div class="small-mobile">
								<ul class="nav navbar-nav navbar-right">
									<li>
										<a href="https://play.google.com/apps/testing/com.incendiary.cedar" target="_blank">
											<img src="/img/google.png" class="img img-responsive" alt="">
										</a>
									</li>
									<li>
										<a href="#ios" class="page-scroll">
											<img src="/img/apple.png" class="img img-responsive" alt="">
										</a>
									</li>
								</ul>
							</div>
						</div>
					</nav>
				</div>
			</header>
			
			
			<div id="main-content">
				<section class="about-section ">
					<div class="container">
						<div class="row">
							<div class="col-md-8 col-lg-8">
								<div class="about">
									<h1>About Us</h1>
									<p>Cedar was built by a team of folks who believe in the <a href="http://www.nytimes.com/2013/07/09/science/what-is-nostalgia-good-for-quite-a-bit-research-shows.html" target="_blank">positive benefits of nostalgia.</a>
										<br>
										<br>
										We decided it was time to digitize the keepsake box - utilized by nostalgia keepers for generations - and make it easier to save and share keepsakes and mementos as digital artifacts.
										<br>
										<br>
										Instead of dusty shoeboxes packed away and unseen for years, we think that everyone can benefit from a personalized archive of memory refreshers available 24/7 right in your pocket.
										<br>
										<br>
										Our hope is that Cedar will increase keepsake "keeping," increase sharing and story-telling, and spark conversations between generations of family and friends.
										<br>
										<br>
										Cedar is currently testing an alpha version of the app for Android. We have lots and lots of product ideas and enhancements in mind for the future, but for now we greatly welcome your feedback on the Cedar App.
										<br>
										<br>
										Please send any and all comments to <a href="mailto:hello@getcedar.io">hello@getcedar.io</a>. Thank you!
									</p>
									<p></p>
									<p></p>
									<p></p>
									<p></p>
								</div>
							</div>
							<div class="col-md-4 col-lg-4 text-center">
								<div class="border-left"></div>
								<div class="cedar-quote">
									<img class="img img-responsive" src="/img/cedar.png"/>
									<div class="quote">
										<p><i> For he lives twice who can at once employ <br>The present well, and ev'n the past enjoy. </i></p>
										
										- Alexander Pope
									</div>
								</div>
							</div>
						</div>
					</div>
					
					
				</section>
			</div>
			<div id="main-footer">
				<footer>
					<div class="container text-center">
						<div class="social">
							<ul>
								<li>
									<div class="fb-like" data-href="https://www.facebook.com/getcedar/" data-layout="button_count" data-action="like" data-show-faces="true" data-share="false"></div>
								</li>
								<li>
									<img src="/img/cedar-icon.png" class="img" alt="Cedar for keepsakes">
								</li>
								<li>
									<div class="cedar-twitter-likes">
										<a href="https://twitter.com/share" class="twitter-share-button" data-url="https://twitter.com/getcedar/">Tweet</a>
										<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
									</div>
								</li>
							</ul>
						</div>
						<div classs="row">
							<div class="col-xs-6 text-right footer-links"><a href="/user/about_us">About Us</a></div>
							<div class="col-xs-6 text-left footer-links"><a href="/user/contact_us">Contact Us</a></div>
						</div>
						<div classs="row">
							<div class="col-xs-6 text-right footer-links">&copy; Cedar 2015</div>
							<div class="col-xs-6 text-left footer-links">Made in Portland, OR</div>
						</div>
					</div>
				</footer>
			</div>
		</div>
		
		<script src="js/jquery-2.1.4.min.js"></script>
		<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script> -->
		<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.1/jquery-ui.min.js"></script> -->
		<!-- Bootstrap JavaScript -->
		<script src="js/bootstrap.min.js"></script>
		<div id="fb-root"></div>
		<script>(function(d, s, id) {var js, fjs = d.getElementsByTagName(s)[0];
			if (d.getElementById(id)) return;
			js = d.createElement(s); js.id = id;
			js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
			fjs.parentNode.insertBefore(js, fjs);}
			(document, 'script', 'facebook-jssdk'));
		</script>
		<script>
			(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
				(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
				m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
			})(window,document,'script','//www.google-analytics.com/analytics.js','ga');
			ga('create', 'UA-69818316-1', 'auto');
			ga('send', 'pageview');
		</script>
	</body>
</html>