<!DOCTYPE html>
<html lang="">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Cedar App for Keepsakes</title>
	<!-- fonts -->
	<link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,700,500italic,700italic,900|Roboto+Condensed:400,700|Roboto+Mono|Roboto+Slab' rel='stylesheet' type='text/css'>
	<!-- Bootstrap CSS -->
	<link href="css/bootstrap.css" rel="stylesheet">
	<link rel="shortcut icon" href="/img/cedar.png" type="image/x-icon" />
	<!-- custom css -->
	<link href="css/style.css" rel="stylesheet">
	<link href="css/jquery.fullpage.css" rel="stylesheet">
	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		
	</head>
	<body>
		<div id="fb-root"></div>
		<script>(function(d, s, id) {var js, fjs = d.getElementsByTagName(s)[0];
			if (d.getElementById(id)) return;
			js = d.createElement(s); js.id = id;
			js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
			fjs.parentNode.insertBefore(js, fjs);}
			(document, 'script', 'facebook-jssdk'));
	</script>
	<!-- <header>
		<div class="menu">
			<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
				<div class="container">
					<div class="navbar-header">
						<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-navbar-collapse-1" aria-expanded="false">
							<span class="sr-only">Toggle navigation</span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
						<a class="navbar-brand" href="#">
							<img class="logo-nav img img-responsive" alt="logo" src="img/cedar-logo.svg">
						</a>
					</div>
					<div class="collapse navbar-collapse" id="bs-navbar-collapse-1">
						<ul class="nav navbar-nav navbar-right">
							<li>
								<a href="#">
									<img src="img/googleplay-icon.png" class="img img-responsive" alt="">
								</a>
							</li>
							<li>
								<a href="#">
									<img src="img/iosapp-icon.png" class="img img-responsive" alt="">
								</a>
							</li>
						</ul>
					</div>
				</div>
			</nav>
		</div>
	</header> -->

	<div id="fullpage">
		<div class="section active">
			<section id="section0" class=" home-section">
				<div class="container">
					<div class="row text-center">
						<div class="cedar-mobile col-md-5 col-sm-12">
							<img src="img/cedar-mobile-app.png" class="img" alt="Image">
						</div>
						<div class="col-md-7 col-sm-12">
							<div class="box">
								<div class="logo text-center">
									<img src="img/cedar-logo.svg"  class=" img " alt="">
								</div>
								<div class="content">
									<h2>The App for Keepsakes</h2>
									<p>Cedar is a photo journal app to help you capture, organize and engage with your mementos. Save the story behind every keepsake. Build your personal archive of nostalgia.</p>
								</div>
								<div class="download ">
									<ul>
										<li><a href=""><img src="img/googleplay-icon.png" class="img img-responsive " alt=""></a></li>
										<li><a href="#comingsoon" class="page-scroll"><img src="img/iosapp-icon.png" class="img img-responsive " alt=""></a></li>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class=" text-center col-xs-12 col-sm-12 col-md-12 col-lg-12">
							<div class="scroll-down">
								<span><a href="#comingsoon" class="page-scroll"><img src="img/down.png" alt="scroll down"></a></span>
								<a href="#comingsoon" class="page-scroll"><p>Scroll Down</p></a>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		<div class="section">
			<section id="section1" class="feature-section">
				<div class="container">
					<div class="">
						<div class="row">
							<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
								<div class="headline text-center">
									<h3>Features</h3>
									
									<span>
										<img src="img/cedarbox-icon.png" class="box-icon img " alt="">
									</span>
									
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
								<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
									<div class="feature-detail">
										<div class="round-icon">
											<span class="lnr lnr-camera">
											</span>
											<h4>Capture</h4>
										</div>
										<p>
											Add details like the story and date for each keepsake photo.
										</p>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
									<div class="feature-detail">
										<div class="round-icon">
											<span class="lnr lnr-layers">
											</span>
											<h4>Organize</h4>
										</div>
										<p>
											Store photos by
											theme and timeframe
											to organize your
											collection.
										</p>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
									<div class="feature-detail">
										<div class="round-icon">
											<span class="lnr lnr-rocket">
											</span>
											<h4>Engage</h4>
										</div>
										<p>
											Easily share images on social media and get reminders sent to you automagically.
										</p>
									</div>
								</div>
								<div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
									<div class="feature-detail">
										<div class="round-icon">
											<span class="lnr lnr-picture">
											</span>
											<h4>Create</h4>
										</div>
										<p>
											Incorporate keepsakes into personalized e-cards or everyday items like tote bags & coffee mugs.
										</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		<div class="section">
			<section id="section2" class=" gallery-section">
				<div class="container">
					<div class="row">
						<div class="">
							<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
								<div class="headline2 text-center">
									<h3>Keepsakes Gallery</h3>
									
									<span>
										<img src="img/cedarboxwhite-icon.png" class="box-icon img " alt="">
									</span>
									
								</div>
							</div>
							<div class="text-center col-xs-12 col-sm-12 col-md-12 col-lg-12">
								<div class="gallery">
									<ul>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image1.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image2.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image3.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image4.png" alt="">
											</div>
										</li>
									</ul>
									<ul>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image2.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image3.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image6.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image1.png" alt="">
											</div>
										</li>
									</ul>
									<ul>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image5.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image1.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image4.png" alt="">
											</div>
										</li>
										<li>
											<div class="meta-box">
												<div class="title"><img src="img/cedarbox.png" alt="cedar box"><h4> Artwork</h4></div>
												<span class="date">10 July 2015</span>
												<p>
													Found this masterpiece from
													my colleague’s desk. Made with
													wax and stone mixtures.
												</p>
												
											</div>
											<div class="box-image">
												<img src="img/gallery-image7.png" alt="">
											</div>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		<div class="section">
			<section id="section3" class=" coming-section">
				<div class="container">
					<div class="row">
						<div class="subscribe">
							<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
								<div class="col-xs-1 col-sm-1 col-md-1 col-lg-1">
								</div>
								<div class="text-center col-xs-12 col-sm-6 col-md-3 col-lg-3">
									<img src="img/apple-icon.png" class="img apple-icon" alt="">
								</div>
								<div class="col-xs-12 col-sm-6 col-md-8 col-lg-8">
									<div class="callaction">
										<h1>Cedar for iOS is coming soon</h1>
										<span>Join our waiting list and you will be the first to know when Cedar launches for iPhone and iPad.
										</span>
										<div class="form-inline mailform">
											<div class="form-group">
												<!-- <label class="sr-only" for="">label</label> -->
												<input type="email" id="ios_email" class="form-control" id="" placeholder="Email Address">
											</div>
											<button type="submit" class="btn btn-color" onclick="myFunction()">Let me Know</button>
											<br/><div id="ios_email_div" class="confirm" ></div>
											<div id="error-email" style="color:red" ></div><br/>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<div class="scroll">
				<a href="#home" class="scrollup"><img src="img/scroll-up.png" alt=""></a>
			</div>
			<footer>
				<div class="container text-center">
					<div class="social">
						<ul>
							<li>
								<div class="fb-like" data-href="https://www.facebook.com/getcedar/" data-layout="button_count" data-action="like" data-show-faces="true" data-share="false"></div>
							</li>
							<li>
								<img src="img/cedar-icon.png" class="img" alt="">
							</li>
							<li>
								<div class="cedar-twitter-likes">
									<a href="https://twitter.com/share" class="twitter-share-button" data-url="https://twitter.com/getcedar/">Tweet</a>
									<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
								</div>
							</li>
						</ul>
					</div>
					<div classs="row">
						<div class="col-xs-6 text-right footer-links"><a href="">About Us</a></div>
						<div class="col-xs-6 text-left footer-links"><a href="">Contact Us</a></div>
					</div>
					<div classs="row">
						<div class="col-xs-6 text-right footer-links">&copy; Cedar 2015</div>
						<div class="col-xs-6 text-left footer-links">Made in Portland, OR</div>
					</div>
				</div>
			</footer>
		</div>
	</div>
	<!-- jQuery -->
	<script src="js/jquery-2.1.4.min.js"></script>
	
	<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script> -->
	<!-- // <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.1/jquery-ui.min.js"></script> -->
	<!-- Bootstrap JavaScript -->
	<script src="js/bootstrap.min.js"></script>
	<script src="js/jquery.fullpage.js"></script>
	<script src="js/jquery.easings.min.js"></script>
	<script src="js/jquery.slimscroll.js"></script>
	<script src="js/retina.min.js"></script>
	<script src="js/scripts.js"></script>
	<script type="text/javascript">
		
		function myFunction()
		{
			$email = $('#ios_email').val();
			
			var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
			
			if($email == '')
			{
				document.getElementById('ios_email_div').innerHTML ="" ;
				document.getElementById('error-email').innerHTML = "Email field cannot be empty";
			}
			else if (filter.test($email))
			{
				$.ajax({
					url: '/site/add-waiting-iosusers',
					type: 'post',
					data:{
						'email':$email,
					},
					success: function (response) {
					//	alert(response);
					if(response == true)
					{
								//	$('#ios_email').val() = '';
								document.getElementById('ios_email').value = "";
								document.getElementById('error-email').innerHTML ="" ;
						//alert($('#ios_email').val());
						document.getElementById('ios_email_div').innerHTML = "Thank you for your interest in Cedar! You will be among the first to know when our iOS app is ready.";
					}
					else
					{
							//alert("please enter a skill");
							document.getElementById('ios_email_div').innerHTML ="" ;
							document.getElementById('error-email').innerHTML = "Your email id is already registered in the waiting list";
						}
					}
					
				});
				
				
				
			}
			else
			{
					//alert("please enter a skill");
					document.getElementById('ios_email_div').innerHTML ="" ;
					document.getElementById('error-email').innerHTML = "Please enter a Valid Email ID";
				}
			}
			$(document).ready(function() {
				document.getElementById('ios_email').value = "";
				$('#fullpage').fullpage({
					// 'verticalCentered': false,
					lockAnchors: false,
					anchors:['top', 'features', 'gallery', 'ios'],
					scrollBar: false,
					lockAnchors: false,
					touchSensitivity: 15,
					autoScrolling: true,
					keyboardScrolling: true,
					scrollOverflow:true
				});
				$(document).on('click', '.scroll-down', function(){
					$.fn.fullpage.moveTo('section2', 1);
				});
				$(document).on('click', '.scrollup', function(){
					$.fn.fullpage.moveTo('section1', 1);
				});
			});
		</script>
	</body>
	</html>