<?php
namespace common\models;

use Yii;
use common\models\Photo;
/*use yii\base\NotSupportedException;
use yii\behaviors\TimestampBehavior;*/
use yii\db\ActiveRecord;
use yii\web\IdentityInterface;
/*use yii\web\Link;
use yii\web\Linkable;*/
/**
 * User model
 *
 * @property integer $id
 * @property string $username
 * @property string $password_hash
 * @property string $password_reset_token
 * @property string $email
 * @property string $auth_key
 * @property integer $status
 * @property integer $created_at
 * @property integer $updated_at
 * @property string $password write-only password
 */
class User extends ActiveRecord implements IdentityInterface
{
    const STATUS_DELETED = 0;
    const STATUS_ACTIVE = 10;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        //return '{{%user}}';
        return 'user';
    }

    /**
     * @inheritdoc  Commented by incendiary as it was creating issue without created_at field in db
     */
    /*public function behaviors()
    {
        return [
            TimestampBehavior::className(),
        ];
    }*/

    /**
     * @inheritdoc
     */
    public function rules()
    {
        /*return [
            ['status', 'default', 'value' => self::STATUS_ACTIVE],
            ['status', 'in', 'range' => [self::STATUS_ACTIVE, self::STATUS_DELETED]],
        ];*/
	return [
            [['first_name', 'last_name','password','profile_picture','status'], 'string'],
	    [['first_name', 'last_name','email','password'], 'required'],
	    [['email'], 'email'],
	    [['email_notifications','mobile_data','share_count'],'integer'],
	    [['email', 'password_reset_token'], 'string', 'max' => 255],
            [['id'], 'integer'],
            [['created_on', 'modified_on'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public static function findIdentity($id)
    {
        return static::findOne(['id' => $id, 'status' => self::STATUS_ACTIVE]);
    }

    /**
     * @inheritdoc
     */
    public static function findIdentityByAccessToken($token, $type = null)
    {
        throw new NotSupportedException('"findIdentityByAccessToken" is not implemented.');
    }

    /**
     * Finds user by username
     *
     * @param string $username
     * @return static|null
     */
    public static function findByUsername($username)
    {
        //return static::findOne(['username' => $username, 'status' => self::STATUS_ACTIVE]);
    }

    /**
     * Finds user by password reset token
     *
     * @param string $token password reset token
     * @return static|null
     */
    public static function findByPasswordResetToken($token)
    {
        /*if (!static::isPasswordResetTokenValid($token)) {
            return null;
        }*/

        return static::findOne([
            'password_reset_token' => $token/*,
            'status' => self::STATUS_ACTIVE,*/
        ]);
    }

    /**
     * Finds out if password reset token is valid
     *
     * @param string $token password reset token
     * @return boolean
     */
    public static function isPasswordResetTokenValid($token)
    {
        if (empty($token)) {
            return false;
        } 
        $expire = 3600;
        $parts = explode('_', $token);
        $timestamp = (int) end($parts);
        return $timestamp + $expire >= time();
    }

    /**
     * @inheritdoc
     */
    public function getId()
    {
        return $this->getPrimaryKey();
    }

    /**
     * @inheritdoc
     */
    public function getAuthKey()
    {
        return $this->auth_key;
    }

    /**
     * @inheritdoc
     */
    public function validateAuthKey($authKey)
    {
        return $this->getAuthKey() === $authKey;
    }

    /**
     * Validates password
     *
     * @param string $password password to validate
     * @return boolean if password provided is valid for current user
     */
    public function validatePassword($password)
    {
        return Yii::$app->security->validatePassword($password, $this->password_hash);
    }

    /**
     * Generates password hash from password and sets it to the model
     *
     * @param string $password
     */
    public function setPassword($password)
    {
        //$this->password_hash = Yii::$app->security->generatePasswordHash($password);
	$this->password = $password;
    }

    /**
     * Generates "remember me" authentication key
     */
    public function generateAuthKey()
    {
        $this->auth_key = Yii::$app->security->generateRandomString();
    }

    /**
     * Generates new password reset token
     */
    public function generatePasswordResetToken()
    {
        $this->password_reset_token = Yii::$app->security->generateRandomString() . '_' . time();
    }

    /**
     * Removes password reset token
     */
    public function removePasswordResetToken()
    {
        $this->password_reset_token = null;
    }
    /**
     * Filter out some fields, best used when you want to inherit the parent implementationand blacklist some sensitive fields.
     */
    public function fields()
    {
        $fields = parent::fields();
        // remove fields that contain sensitive information
        unset($fields['password']);
        return $fields;
    }
    /**
     * Used to fetch extra fields whenever requested by api
     */
    public function extraFields()
    {
        return ['password'];
    }

    //Function used to send password reset email
    public function sendEmail($email)
    {
        
	$user = User::findOne([
            'email' => $email
        ]);

	if ($user) { 
		if (!User::isPasswordResetTokenValid($user->password_reset_token)) {
                	$user->generatePasswordResetToken();
			
                }
		if ($user->save()) {
			return \Yii::$app->mailer->compose(['html' => 'passwordResetToken-html', 'text' => 'passwordResetToken-text'], ['user' => $user])
		            ->setFrom(['emails@getcedar.io'=>'Cedar'])
		            ->setTo($email)
		            ->setSubject('Password reset for Cedar')
		            ->send();
		}
	}
        return false;
    }
	
	/**
     * @return \yii\db\ActiveQuery
     */
    public function getPhoto()
    {
        return $this->hasOne(Photo::className(), ['user_id' => 'id']);
    }
	
	/**
     * @return \yii\db\ActiveQuery
     */
    public function getCount()
    {
        return Photo::find()->where(['user_id' => $this->id])->count();
    }
	
	/**
     * @return \yii\db\ActiveQuery
     */
    public function getFirst_captured()
    {
        return Photo::find()->where(['user_id' => $this->id])->orderBy('created_on asc')->one();
    }
	
	/**
     * @return \yii\db\ActiveQuery
     */
    public function getLast_captured()
    {
        return Photo::find()->where(['user_id' => $this->id])->orderBy('created_on desc')->one();
    }
}
