<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "photo".
 *
 * @property integer $id
 * @property string $image
 * @property string $note
 * @property string $keepsake_date
 * @property integer $user_id
 * @property integer $box_id
 * @property string $created_on
 * @property string $modified_on
 * @property integer $status
 *
 * @property Box $box
 * @property User $user
 */
class Photo extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'photo';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['image', 'note'], 'string'],
            [['user_id', 'box_id'], 'required'],
            [['user_id', 'box_id', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['keepsake_date'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'image' => 'Image',
            'note' => 'Note',
            'keepsake_date' => 'Keepsake Date',
            'user_id' => 'User ID',
            'box_id' => 'Box ID',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBox()
    {
        return $this->hasOne(Box::className(), ['id' => 'box_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
