<?php

namespace common\models;
use Yii;
use yii\base\NotSupportedException;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveRecord;
use yii\web\IdentityInterface;

/**
 * This is the model class for table "ios_waiting_list".
 *
 * @property integer $id
 * @property string $email_id
 */
class IosWaitingList extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ios_waiting_list';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['email_id'], 'required'],
            [['email_id'], 'string', 'max' => 250],
            [['email_id'],'unique']
        ];
    }
	
	/**
     * @inheritdoc
     */
    public function behaviors()
	{
	    return [
	        'timestamp' => [
	            'class' => TimestampBehavior::className(),
	            'attributes' => [
	                ActiveRecord::EVENT_BEFORE_INSERT => 'created_on',
	            ],
	            'value' => function() { return date('Y-m-d H:i:s'); // current date
	            },
	        ],
	    ];
	}
	
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'email_id' => 'Email ID',
        ];
    }
}
