<?php

//use yii;
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use frontend\widgets\Alert;
use yii\widgets\Pjax;

?>
<!--<div class="container customFonts p50 pb20">-->
<?= Alert::widget() ?>
	
    
    	<div id="user-view" class="user-view">
    		<?php Pjax::begin(); ?>
			 <?= GridView::widget([
			        'dataProvider' => $dataProvider,
			        'filterModel' => $searchModel,
			        
			        'columns' => [
			            //['class' => 'yii\grid\SerialColumn'],
			
			            //'id',
			            [
			            'attribute' => 'id',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label' => 'ID',
			            'format' => 'raw',
			            'value' => 'id'
						],
			           // 'user_id',
			           [
			            'attribute' => 'user_id',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label' => 'User ID',
			            'value' => 'user_id'
						],
			            [
			            'attribute'=>'created_on',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label'=> 'Saved',
						'value' => 'created_on'
						 ],
						// 'keepsake_date',
			             //'notes',
			           // 'keepsake_date',
			            //'note:ntext',
			            [
			            'attribute'=>'keepsake_date',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label'=> 'KeepSake Date',
						'value' => 'keepsake_date'
						 ],
			            //'note:ntext',
			            [
			            'attribute'=>'note',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label'=> 'Note',
						'value' => 'note'
						 ],
			            [
			            'attribute'=>'box',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label'=> 'Box Assigned',
						'value' => 'box.name'
						 ],
						 [
			            'attribute'=>'image',
			            'filterInputOptions' => [
			                'class'       => 'form-control',
			                'placeholder' => 'Search ...'
			             ],
			            'label'=>'Saved Image',
			            'format' => 'raw',
			            'value'=>function ($data) {
			             	return Html::a($data['image'],$data['image'],['target'=>'_blank']);
			        		},
			        
			            ],
			           // ['class' => 'yii\grid\ActionColumn'],
			            [
						  'class' => 'yii\grid\ActionColumn',
						  'template' => '{view-photo}{update-photo}{delete-photo}',
						  'buttons' => [
						    'view-photo' => function ($url, $model) {
						        return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url, [
						                    'title' => Yii::t('app', 'View'),$options = ['data-method' => 'post'],
						        ]);
						    },
							'update-photo' => function ($url, $model) {
						        return Html::a('<span class="glyphicon glyphicon-pencil"></span>', $url, [
						                    'title' => Yii::t('app', 'Update'),$options = ['data-method' => 'post'],
						        ]);
						    },
							'delete-photo' => function ($url, $model) {
						        return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url, [
						                    'title' => Yii::t('app', 'Delete'),'data-method'=>'post',
						        ]);
						    },
						  ],
						  
						  'urlCreator' => function ($action, $model, $key, $index) {
						   // if ($action === 'new_action1') {
						        $url ='/backend/web/index.php?r=user/'.$action.'&id='.$model->id.'&user_id='.$model->user_id;
						        return $url;
						   // }
						  }
						]
			        ],
			    ]); ?>
			    <?php Pjax::end(); ?>
	
		</div>
		
	
	

