<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\AdminSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Admins';
$this->params['breadcrumbs'][] = $this->title;
?>
<script>
	function ip_selected($id)
	{
		window.location.replace("/backend/web/index.php?r=super-admin/ip-index");
		
	}
</script>
<div class="col-md-12 col-sm-12 ">
				<ul class="nav nav-tabs">
  					<li id = "admin_li" class="active"><a href="#admin" data-toggle="tab" >Admin Management</a></li>
  					<li id = "ips_li"><a href="#ips" data-toggle="tab" onclick="ip_selected();">IP management</a></li>
				</ul>
</div>
<div class="admin-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Admin', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
	
	<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
          //  ['class' => 'yii\grid\SerialColumn'],
			[
            'attribute' => 'id',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label' => 'ID',
            'format' => 'raw',
            'value' => function ($data) {
             	return Html::a($data['id'],Url::to(['super-admin/view', 'id'=>$data['id']]));
        		},
			],
			
			[
            'attribute' => 'username',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label' => 'Username',
            'format' => 'raw',
            'value' => function ($data) {
             	return Html::a($data['username'],Url::to(['super-admin/view', 'id'=>$data['id']]));
        		},
			],
            
            [
            'attribute'=>'email',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label'=> 'Email Address',
            'format' => 'raw',
			'value' => function ($data) {
             	return $data['email'];
        		},
			 ],
            [
            'attribute'=>'created_at',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label'=> 'Created On',
			'value' => 'created_at'
			 ],
			 [
            'attribute'=>'updated_at',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label'=> 'Updated On',
			'value' => 'updated_at'
			 ],
			 [
            'attribute'=>'status',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label'=> 'Status',
			'value' => 'status'
			 ],
			 [
            'attribute'=>'is_superadmin',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label'=> 'Is Super Admin?',
			'value' => 'is_superadmin'
			 ],
			 /*
            'id',
            'username',
            //'auth_key',
            //'password_hash',
            //'password_reset_token',
            'email:email',
            'status',
            'created_at',
            'updated_at',*/

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>

</div>
