<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use frontend\widgets\Alert;
use yii\helpers\Url;
use yii\web\Session;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\ipSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Allowed Ips';
$this->params['breadcrumbs'][] = $this->title;
?>
<?= Alert::widget() ?>
<?= Yii::$app->session->getFlash('success'); ?>
<?= Yii::$app->session->getFlash('error'); ?>
<script>
$(document).ready(function()
{
	$('input:checkbox').change(function(e)
	{
		var id = $(this).val();
		checked = $(this).is(':checked');
		$.ajax({
		       url: '/backend/web/index.php?r=super-admin/update-allowed',
		       type: 'post',
		       data:{id:id,
		       		checked:checked},
		       success: function (response) {
		       		window.location.reload();
		       	}
	       
	  	});
	});
});


function check_box()
{
	
}
	function admin_selected($id)
	{
		window.location.replace("/backend/web/index.php?r=super-admin/index");
		
	}
	
</script>
<div class="col-md-12 col-sm-12 ">
				<ul class="nav nav-tabs">
  					<li id = "admin_li"><a href="#admin" data-toggle="tab" onclick="admin_selected();">Admin Management</a></li>
  					<li id = "ips_li" class="active"><a href="#ips" data-toggle="tab">IP management</a></li>
				</ul>
</div>

<div class="allowed-ips-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p><!--
        <?= Html::a('Create Allowed Ips', ['ip-create'], ['class' => 'btn btn-success']) ?>
       -->
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

            //'id',
           //'username',
            [
            'attribute' => 'id',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label' => 'ID',
            'format' => 'raw',
            'value' => function ($data) {
             	return Html::a($data['id'],Url::to(['super-admin/ip-view', 'id'=>$data['id']]));
        		},
			],
            //'admin_id',
            [
            'attribute' => 'admin_id',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label' => 'Admin ID',
            'format' => 'raw',
            'value' => function ($data) {
             	return Html::a($data['admin_id'],Url::to(['super-admin/view', 'id'=>$data['admin_id']]));
        		},
			],
            //'allowed',
            //'ip_address',
            [
            'attribute' => 'ip_address',
            'filterInputOptions' => [
                'class'       => 'form-control',
                'placeholder' => 'Search ...'
             ],
            'label' => 'IP Address',
            'format' => 'raw',
            'value' => 'ip_address', 
            ],
            [
            //'attribute'=>'allowed',
            //'label' => 'Allowed',
            //'contentOptios'=>
            //'id'=>'Allowed',
            'header'=>'<label style = "color:#C55;"><b>Allowed</b></label>',
	        'class' => 'yii\grid\CheckboxColumn',
	        'checkboxOptions'=>function ($model, $key, $index, $column) {
	        	$checked = $model->allowed == 'yes'?true:false;
	        return ['id'=>'allowed_'.$model->id,'value' => $model->id,'checked'=>$checked];
			},
			
	        ],
	        
            //['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>

</div>
