<?php

namespace backend\models;

use common\models\User;
use common\models\Photo;
use common\models\UserLoginHistory;
use yii\base\Model;
use yii\db\Query;
use yii\helpers\Url;
use yii;

class userProfileForm extends Model
{
	public function get_user_details($id)
	{
		return User::findOne(['id'=>$id]);
	}
	
	public function get_user_photos($id)
	{
		/*
		return Photo::find()
		->select('box.id,box.name')
		->leftJoin('box','photo.box_id = box.id')
		->where(["=","photo.user_id","{$id}"])
		->all();
		 * */
		 $connection = \Yii::$app->db;
		 $model = $connection->createCommand('SELECT photo.*,box.name 
		 		FROM photo
		 		LEFT JOIN box ON photo.box_id = box.id
		 		WHERE photo.user_id = '.$id);
				
		//$model = photo::findBySql($sql)->all();
		
		return $model->queryAll();

	}
	
	public function export_csv($ids)
	{
		//Yii::import('ext.ECSVExport');
		$connection = \Yii::$app->db;
		$model = $connection->createCommand(
				'SELECT photo.id, 
						photo.user_id,
						photo.created_on,
						photo.keepsake_date,
						photo.note,
						box.name,
						photo.image
		 		FROM photo
		 		LEFT JOIN box ON photo.box_id = box.id
		 		WHERE photo.user_id = '.$ids['user_id']);
				
		//$model = photo::findBySql($sql)->all();
		
		$data =  $model->queryAll();
		
		//print_r($data);
		//$csv = new ECSVExport($data);
		$filename = '../web/files/'.$ids['user_id'].'_photos_exported.csv';
		$fp = fopen($filename, 'w');
		
		$header = array();
		$header[0] = 'Photo ID';
		$header[1] = 'User ID';
		$header[2] = 'Saved';
		$header[3] = 'Keepsake Date';
		$header[4] = 'Note';
		$header[5] = 'Box Assigned';
		$header[6] = 'Saved Image';
		
		fputcsv($fp,$header);
		//$csv->toCSV($filename); // returns string by default
		foreach($data as $row)
		{
			fputcsv($fp,$row);
		}
 		
		return $filename;
		//echo file_get_contents($filename);
		
		
		//die();
	}

	public function export_user_csv()
	{
		//Yii::import('ext.ECSVExport');
		$connection = \Yii::$app->db;
		$model = $connection->createCommand(
				'SELECT user.id,
				user.first_name,
				user.last_name,
				user.email,
				user.status,
				user.created_on,
				min(photo.created_on) as first_captured, 
				max(photo.created_on) as last_captured, 
				count(photo.id) as captured
				from user
				Left Join photo
				ON photo.user_id = user.id
				GROUP BY user.id');
		 		
				
		//$model = photo::findBySql($sql)->all();
		
		$data =  $model->queryAll();
		
		//print_r($data);
		//$csv = new ECSVExport($data);
		$filename = '../web/files/exported_users.csv';
		$fp = fopen($filename, 'w');
		
		$header = array();
		$header[0] = 'User ID';
		$header[1] = 'First Name';
		$header[2] = 'Last Name';
		$header[3] = 'Email Address';
		$header[4] = 'Status';
		$header[5] = 'Created On';
		$header[6] = 'First Captured';
		$header[7] = 'Last Captured';
		$header[8] = 'Captured';
		$header[9] = 'Last Login Time';
		$header[10] = 'Device Model';
		$header[11] = 'OS Version';
		$header[12] = 'Application Version';
		
		fputcsv($fp,$header);
		
		//$csv->toCSV($filename); // returns string by default
		foreach($data as $row)
		{
			$login = UserLoginHistory::find()->where(['user_id' => $row['id']])->orderBy('login_time desc')->one();
			//print_r($login);
			//die();
			$row['login_time'] = $login['login_time'];
			$row['device_model'] = $login['device_model'];
			$row['os_version'] = $login['os_version'];
			$row['app_version'] = $login['app_version'];
			fputcsv($fp,$row);
		}
 		
		return $filename;
	}
	
	public function delete_user($id)
	{
		$sql = " DELETE FROM photo WHERE user_id = {$id}";
		
		$command = Yii::$app->db->createCommand($sql);
		
		$command->execute();
		
		$sql1 = " DELETE FROM box WHERE user_id = {$id}";
		
		$command1 = Yii::$app->db->createCommand($sql1);
		
		$command1->execute();
		
		$sql2 = "DELETE FROM user WHERE id = {$id}";
		
		$command2 = Yii::$app->db->createCommand($sql2);
		
		$command2->execute();
		
		return true;
	}
	
	public function update_details($data,$id)
	{
		//print_r($data);
		$user = User::findOne(['id'=>$id]);
		if($user)
		{
			if(isset($data['first_name']))
			{
				$user->first_name = ($data['first_name'] != '')?$data['first_name']:'';
			}
			if(isset($data['last_name']))
			{
				$user->last_name = ($data['last_name'] != '')?$data['last_name']:'';
			}
			/*
			if(isset($data['email']))
			{
				$user->email = ( $data['email'] != '')?$data['email']:'';
			}*/
			if(isset($data['email_notification']))
			{
				$user->email_notifications = ($data['email_notification'] == true)?1:0;
			}
			if(isset($data['email_notification']) && $data['email_notification'] != 'undefined')
			{
				$user->email_notifications = ($data['email_notification'] == 'true')?1:0;
			}
			if(isset($data['account_status']) && $data['account_status'] != 'undefined')
			{
				$user->status = ($data['account_status'] == 'true')?'active':'inactive';
			}
			if($user->validate())
			{
				if($user->save())
				{
					$data['status'] = true;
					$data['user'] = $user;
					return $data;
				}
				else {
					$data['status'] = false;
					$data['user'] = $user;
					return $data;
				}
			}
			else {
				$data['status'] = false;
					$data['user'] = $user;
					return $data;
			}
			
		}
	}

	public function get_last_login_date($id)
	{
		return  UserLoginHistory::find()
		->where(['user_id' => $id])
		->orderBy([
		'id'=>SORT_DESC,
       ])->limit(1)->One();
		//print_r($data);
	}
	
	public function get_session_count($id)
	{
		return count(UserLoginHistory::findAll(['user_id'=> $id]));
	}
}
