<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Photo;

/**
 * photoSearch represents the model behind the search form about `common\models\Photo`.
 */
class photoSearch extends Photo
{
	public $box;
	public $email;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'box_id', 'status'], 'integer'],
            [['image', 'note', 'keepsake_date', 'created_on', 'modified_on','box','email'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Photo::find()
        ->select('photo.*,user.email')
		->leftJoin('box', '`box`.`id` = `box_id`')
        ->leftJoin('user', '`user`.`id` = `photo`.`user_id`')
		;

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['attributes' => ['id','user_id','created_on','keepsake_date','note','image','email','box']]
        ]);
		
		$dataProvider->setSort([
        'attributes' => [
        	'id',
        	'user_id',
        	'created_on',
        	'keepsake_date',
        	'note',
        	'image',
        	'email',
            //'id',
            'box' => [
                'asc' => ['box.created_on' => SORT_ASC],
                'desc' => ['box.created_on' => SORT_DESC],
                'label' => 'box.created_on',
                'default' => SORT_ASC
            ],
            
        ]
    	]);
		
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
		
        $query->andFilterWhere([
            'photo.id' => $this->id,
            'photo.user_id' => $this->user_id,
            'box_id' => $this->box_id,
            'photo.created_on' => $this->created_on,
            'photo.modified_on' => $this->modified_on,
            'status' => $this->status,
        ]);
		
		$query->andFilterWhere(['like', 'image', $this->image])
            ->andFilterWhere(['like', 'note', $this->note])
            ->andFilterWhere(['like', 'keepsake_date', $this->keepsake_date])
			->andFilterWhere(['like','email',$this->email])
			->andFilterWhere(['like','name',$this->box]);

        return $dataProvider;
    }

	public function photo_serach($params,$id)
	{
		 $query = Photo::find()
        ->select('photo.*,user.email')
		->leftJoin('box', '`box`.`id` = `box_id`')
        ->leftJoin('user', '`user`.`id` = `photo`.`user_id`')
		;

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => ['attributes' => ['id','user_id','created_on','keepsake_date','note','image','email','box']]
        ]);
		
		$dataProvider->setSort([
        'attributes' => [
        	'id',
        	'user_id',
        	'created_on',
        	'keepsake_date',
        	'note',
        	'image',
        	'email',
            //'id',
            'box' => [
                'asc' => ['box.created_on' => SORT_ASC],
                'desc' => ['box.created_on' => SORT_DESC],
                'label' => 'box.created_on',
                'default' => SORT_ASC
            ],
            
        ]
    	]);
		
		$params['user_id'] = $id;
		
		$this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
		
		if(isset($id) && $id !=='')
		{
			 $query->andFilterWhere([
            
            'photo.user_id' => $id,
            
        ]);
		}
        $query->andFilterWhere([
            'photo.id' => $this->id,
            'photo.user_id' => $this->user_id,
            'box_id' => $this->box_id,
            'photo.created_on' => $this->created_on,
            'photo.modified_on' => $this->modified_on,
            'status' => $this->status,
        ]);
		
		$query->andFilterWhere(['like', 'image', $this->image])
            ->andFilterWhere(['like', 'note', $this->note])
            ->andFilterWhere(['like', 'keepsake_date', $this->keepsake_date])
			->andFilterWhere(['like','email',$this->email])
			->andFilterWhere(['like','name',$this->box]);
		
		return $dataProvider;
	}
}
