<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\UserLoginHistory;

/**
 * UserLoginHistorySearch represents the model behind the search form about `common\models\UserLoginHistory`.
 */
class UserLoginHistorySearch extends UserLoginHistory
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id'], 'integer'],
            [['login_time','device_model','app_version','os_version'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params,$id)
    {
        $query = UserLoginHistory::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'login_time' => $this->login_time,
        ]);
		
		$query->andFilterWhere(['like', 'device_model', $this->device_model])
            ->andFilterWhere(['like', 'app_version', $this->app_version])
            ->andFilterWhere(['like', 'os_version', $this->os_version]);
			
		if($id != '')
		{
			 $query->andFilterWhere([
            'user_id' => $id,
            ]);
		}

        return $dataProvider;
    }
}
