<?php

namespace backend\models;

use common\models\User;
use common\models\Photo;
use yii\base\Model;
use yii\db\Query;
use yii\helpers\Url;
use yii;

class PhotoFormModel extends Model
{

	public function export_photo_csv()
	{
		//Yii::import('ext.ECSVExport');
		$connection = \Yii::$app->db;
		$model = $connection->createCommand(
				'SELECT photo.id,
					photo.user_id,
					user.email,
					photo.created_on,
					photo.keepsake_date,
					photo.note,
					box.name,
					photo.image
				FROM photo
				LEFT JOIN box
					ON photo.box_id = box.id
				LEFT JOIN user
					ON photo.user_id = user.id');
		 		
				
		//$model = photo::findBySql($sql)->all();
		
		$data =  $model->queryAll();
		
		//print_r($data);
		//$csv = new ECSVExport($data);
		$filename = '../web/files/exported_photos.csv';
		$fp = fopen($filename, 'w');
		
		$header = array();
		$header[0] = 'Photo ID';
		$header[1] = 'User ID';
		$header[2] = 'Email Address';
		$header[3] = 'Saved';
		$header[4] = 'Keepsake Date';
		$header[5] = 'Note';
		$header[6] = 'Box Assigned';
		$header[7] = 'Image';
		
		
		fputcsv($fp,$header);
		
		//$csv->toCSV($filename); // returns string by default
		foreach($data as $row)
		{
			fputcsv($fp,$row);
		}
 		
		return $filename;
	}
	
	public function get_photo_details($id)
	{
		/*
		return Photo::find()
		->select('photo.*,box.id,box.name,user.email,user.id')
		->leftJoin('box','photo.box_id = box.id')
		->leftJoin('user','photo.user_id=user.id')
		->where(["=","photo.id","{$id}"])
		->one();
		*/
		$connection = \Yii::$app->db;
		$model = $connection->createCommand(
				'SELECT photo.id,
					photo.user_id,
					user.email,
					user.first_name,
					user.last_name,
					photo.created_on,
					photo.modified_on,
					photo.keepsake_date,
					photo.status,
					photo.note,
					box.name,
					photo.image
				FROM photo
				LEFT JOIN box
					ON photo.box_id = box.id
				LEFT JOIN user
					ON photo.user_id = user.id
				WHERE photo.id = '.$id);
		 		
				
		//$model = photo::findBySql($sql)->all();
		
		$data =  $model->queryOne();
		return $data;
	}
}
