<?php

namespace backend\controllers;

use Yii;
use yii\filters\AccessControl;
use common\models\User;
use common\models\Photo;
use backend\models\UserSearch;
use backend\models\photoSearch;
use backend\models\PhotoFormModel;
use backend\models\UserLoginHistorySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\userProfileForm;

/**
 * UserController implements the CRUD actions for User model.
 */
class UserController extends Controller
{
	//public $controller = 'photo';
	
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login','error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['logout', 'index','view','delete','update','session-view','update-user','export-csv','list-export-csv','delete-photo','view-photo','update-photo','user-view','create-photo'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                    
                ],
                
                ],
            	'verbs' => [
	                'class' => VerbFilter::className(),
	                'actions' => [
	                    'logout' => ['post'],
            	],
            ]
        ];
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new UserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
	//	print_r($dataProvider);
		//print_r($searchModel);
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
    	$model = new userProfileForm();
		
		$user = $model->get_user_details($id);
		
		$login_data = $model->get_last_login_date($id);
		
		$session_count = $model->get_session_count($id);
		
		//print_r($login_data)
		$photo_model = new photoSearch();
		
        $dataProvider = $photo_model->photo_serach(Yii::$app->request->queryParams,$id);
		
        /*return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);*/
		//print_r($user);
		$photos = $model->get_user_photos($id);
		//print_r($photos);
		//die();
		//$jsView = file_get_contents(Yii::getAlias('@webroot/js/startup.js'));
		//$this->registerJs($jsView, view::POS_END);
        return $this->render('view', [
            'model' => $this->findModel($id),
            'count'=>count($photos),
            'user'=>$user,
            'session_count' =>$session_count,
            'dataProvider'=>$dataProvider,
            'searchModel'=>$photo_model,
            'login_data'=>$login_data
        ]);
    }
	
	/**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionUserView($id)
    {
    	$model = new userProfileForm();
		
		$user = $model->get_user_details($id);
		
		$session_count = $model->get_session_count($id);
		
		$photo_model = new photoSearch();
		
        $dataProvider = $photo_model->photo_serach(Yii::$app->request->queryParams,$id);

        /*return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);*/
		//print_r($user);
		$photos = $model->get_user_photos($id);
		//print_r($photos);
		//die();
		//$jsView = file_get_contents(Yii::getAlias('@webroot/js/startup.js'));
		//$this->registerJs($jsView, view::POS_END);
        return $this->render('user-view', [
            'model' => $this->findModel($id),
            'count'=>count($photos),
            'session_count' =>$session_count,
            'user'=>$user,
            'dataProvider'=>$dataProvider,
            'searchModel'=>$photo_model
        ]);
    }
	
	/**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionSessionView($id)
    {
    	$model = new userProfileForm();
		
		$user = $model->get_user_details($id);
		
		$login_data = $model->get_last_login_date($id);
		
		$session_count = $model->get_session_count($id);
		
		$photo_model = new UserLoginHistorySearch();
		
        $dataProvider = $photo_model->search(Yii::$app->request->queryParams,$id);

        /*return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);*/
		//print_r($user);
		$photos = $model->get_user_photos($id);
		//print_r($photos);
		//die();
		//$jsView = file_get_contents(Yii::getAlias('@webroot/js/startup.js'));
		//$this->registerJs($jsView, view::POS_END);
        return $this->render('session-view', [
            'model' => $this->findModel($id),
            'count'=>count($photos),
            'user'=>$user,
            'session_count' =>$session_count,
            'dataProvider'=>$dataProvider,
            'searchModel'=>$photo_model,
            'login_data'=>$login_data
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new User();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id,$view=null)
    {
        $model = new userProfileForm();
		$post_data = Yii::$app->request->post();
		$user = $this->findModel($id);
		if($post_data)
		{
			$data = $model->update_details($post_data,$id);
			if($data['status'])
			{
				if(isset($view) && $view =='session')
				{
					return $this->redirect('/backend/web/index.php?r=user/session-view&id='.$id,302);
				}
				else {
					return $this->redirect('/backend/web/index.php?r=user/view&id='.$id,302);
				}
			}
			else {
				//print_r($data['user']->errors);
				//die();
				//if(isset($data['user']->errors['email']))
				return $this->render('update_popup', [
                'model' => $data['user'],
                'email'=>$data['user']->errors['email'],
            ]);
			}
			
		}
		else {
            return $this->render('update_popup', [
                'model' => $user,
            ]);
        }
    }
	
	/**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdateUser($id)
    {
        $model = new userProfileForm();
		$post_data = Yii::$app->request->post();
		$user = $this->findModel($id);
		if($post_data)
		{
			//print_r($post_data);
			$data = $model->update_details($post_data,$id);
			if($data['status'])
			{
				return $this->redirect('/backend/web/index.php?r=user/index');
				
			}
			else {
				//print_r($data['user']->errors);
				//if(isset($data['user']->errors['email']))
				return $this->render('update_popup', [
                'model' => $data['user'],
                'email'=>$data['user']->errors['email']
            ]);
			}
			
		}
		else {
            return $this->renderAjax('update_popup', [
                'model' => $user,
            ]);
        }
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
    	$model = new userProfileForm();
		
		$data = $model->delete_user($id);
		
       // $this->findModel($id)->delete();

        //return $this->redirect(['index']);
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function actionExportCsv()
	{
		//print_r("fghdfkghkh");
		
		$model = new userProfileForm();
		
		$post_data = Yii::$app->request->get();
		
		if(isset($post_data['user_id']))
		{
		$file = $model->export_csv($post_data);
		
		return Yii::$app->response->sendFile($file);
		}
	}
	public function actionListExportCsv()
	{
		$model = new userProfileForm();
		
		//$post_data = Yii::$app->request->get();
		
		$file = $model->export_user_csv();
		if($file)
		{
			//$fp = fopen($file,'r');
			//print_r($file);
			//return \Yii::$app->response->sendStreamAsFile($fp,$file);
			
			return \Yii::$app->response->sendFile($file);
		}
		
		
	}
	
	/**
     * Displays a single Photo model.
     * @param integer $id
     * @return mixed
     */
    public function actionViewPhoto($id,$user_id)
    {
    	$model= new PhotoFormModel();
		
		$data = $model->get_photo_details($id);
		
        return $this->render('/photo/view', [
            'model' => $data,
            'user_id'=>$user_id,
        ]);
    }

    /**
     * Creates a new Photo model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreatePhoto()
    {
        $model = new Photo();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Photo model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdatePhoto($id,$user_id)
    {
        $model = $this->findPhotoModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $user_id]);
        } else {
            return $this->render('/photo/update', [
                'model' => $model,
                'user_id'=>$user_id
            ]);
        }
    }

    /**
     * Deletes an existing Photo model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDeletePhoto($id,$user_id)
    {
        $this->findPhotoModel($id)->delete();
		
        //return $this->redirect(['index']);
         return $this->redirect(['view', 'id' => $user_id]);
    }

    /**
     * Finds the Photo model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Photo the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findPhotoModel($id)
    {
        if (($model = Photo::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
