<?php
namespace backend\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use common\models\LoginForm;
use yii\filters\VerbFilter;
use common\models\AdminLoginForm;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['logout', 'index'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionIndex()
    {
    	return $this->redirect('/backend/web/index.php?r=user/index',302);
        //return $this->render('index');
    }

    public function actionLogin()
    {
    	$ip = Yii::$app->getRequest()->getUserIP();
		//print_r($ip);
    	$model = new AdminLoginForm();
		//print_r(Yii::$app->request->post());
        if ($model->load(Yii::$app->request->post()) ) 
        {
        	$model->ip = $ip;
        	if($model->login())
			{
				// return $this->goBack();
				//return $this->redirect('index.php?r=/user/index',302);
           		return $this->redirect('index.php?r=/user/index');  
			}
			else 
			{
				//print_r($model->errors);
				//If any validation errors are ther, display that
        		return $this->render('login', [
                'model' => $model
            ]);
        	}
           
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }
}
