<?php
namespace api\modules\v1\controllers;

use Yii;
use yii\rest\ActiveController;
use common\models\LoginForm;
use common\models\User;
use frontend\models\Photo;
use yii\filters\auth\CompositeAuth;
use yii\filters\auth\HttpBasicAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\filters\auth\QueryParamAuth;
use yii\data\ActiveDataProvider;

class UserController extends ActiveController
{
    // We are using the regular web app modules:
    public $modelClass = 'common\models\User';
    public function actions()
    {
        $actions = parent::actions();
        // disable the "delete"  actions
        unset($actions['delete']);
        return $actions;
    }
    //Method to search for an item in db with matching get value request. This is used for email and password check
    public function actionSearch()
    {
	$post_data = Yii::$app->request->post();
        if (!empty($post_data)) {
            $model = new $this->modelClass;
                foreach (Yii::$app->request->post() as $key => $value) {
                    if (!$model->hasAttribute($key)) {
                        throw new \yii\web\HttpException(404, 'Invalid attribute:' . $key);
                    }
                }
            try {
                $provider = new ActiveDataProvider([
                    'query' => $model->find()->where(Yii::$app->request->post()),
                    'pagination' => false
                ]);
            } catch (Exception $ex) {
                throw new \yii\web\HttpException(500, 'Internal server error');
            }

            if ($provider->getCount() <= 0) {
                throw new \yii\web\HttpException(404, 'No entries found with this query string');
            } else {
                return $provider;
            }
	    } else {
		throw new \yii\web\HttpException(400, 'There are no query string');
	    }
    }
    public function actionReset_password()
    {
	$post_data = Yii::$app->request->post();
        if (!empty($post_data)) {
		$model = new $this->modelClass;
		$model->sendEmail($post_data['email']);
	} else {
		throw new \yii\web\HttpException(400, 'There are no query string');
	}
    }
}
?>
